<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_Damage_Customer extends CI_Controller {

    var $main_menu_name = "product_damage_customer";
	var $sub_menu_name = "product_damage_customer";

	public function __construct()
	{
		parent::__construct();
        $this->load->model('Sales_Model');
		$this->load->model('Product_Damage_Customer_Model');
		$this->load->model('Product_Damage_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Tax_Rates_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Sequerty_Model');
		$this->load->model('Return_Damage_Cus_Model');
	}
	
	//Product_ Damage list page load
	public function index()
	{
		//$data['product_damage'] = $this->Product_Damage_Model->get_all_product_damage();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('product_damage_customer',$data);
	}	
	
	//Product  Damage details view
	public function view()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = '';
		
		//get sale id
		$cus_damage_id=$this->uri->segment('3');
		//echo $cus_damage_id;
		$data['cus_damage_id']=$cus_damage_id;
		
		$data['cus_damage_details']= $this->Product_Damage_Customer_Model->get_cus_damage_details($cus_damage_id);
		$data['sale_details']=$this->Sales_Model->get_sale_info($data['cus_damage_details']['sale_id']);
		//$data['pdmg_details']= $this->Product_Damage_Model->get_pdmg_info($pdmg_id);
		
	
		$data['customer_details']= $this->Customer_Model->get_customer_info($data['cus_damage_details']['cus_id']);
		$data['warehouse_details']= $this->Warehouse_Model->get_warehouse_info($data['cus_damage_details']['warehouse_id']);		
		$data['cus_damage_item_details']= $this->Product_Damage_Customer_Model->get_cus_damage_item_details($cus_damage_id);
		
        $this->load->view('cus_damage_view',$data);
	}

		
	
	//Product  Damage payment page 
	
	
	//Product  Damage save 
	//Product  Damage item save
	//Add product_damage items to 54 table
	public function save_product_damage_customer()
	{   $customer_id='';
		$pdmg_reference_no=$this->input->post('pdmg_reference_no');
		$invoice_id=$this->input->post('invoice_id');
		//$sale_id=$this->Product_Damage_Customer_Model->get_sale_id($invoice_id);
		//$inc_id=$sale_id[0]['sale_id'];
		//$data['customer_id']=$this->Product_Damage_Customer_Model->get_sale_details($invoice_id);
		$reference_no=$this->input->post('reference_no');
		//$customer_id=$data['sale_details']['customer_id'];
        //alert ($customer_id);
		$customer_id=$this->input->post('cus_id');
		$warehouse_id=$this->input->post('warehouse_id');
		$rowCount=$this->input->post('rowCount');
		$recieved_id=$this->input->post('recieved_id');
		$pdmg_datetime=$this->input->post('pdmg_datetime');
		$pdmg_datetime=date('Y-m-d H:i:s');
		$user_id=$this->input->post("user_id");
		//$pdmg_inv_discount=$this->input->post('pdmg_inv_discount');		
		//$pdmg_total=$this->input->post('pdmg_total');
		
		$pdmg_datetime_created=date('Y-m-d H:i:s');
		
		$error='';
		$disMsg='';
		$lastid='';
		$cus_damage_id='';
		
		if(!$error){
			$data=array(
				'cus_id'=>$customer_id,
				'warehouse_id'=>$warehouse_id,
				'sale_id'=>$invoice_id,
				'reference_no'=>$reference_no,
				'recieved_person_id'=>$recieved_id,
				'recieved_date'=>$pdmg_datetime,
				'user_id'=>$user_id,
				'syystem_datetime'=>$pdmg_datetime_created
			);
			$_insert=$this->Product_Damage_Customer_Model->save_product_damage_customer($data,$cus_damage_id);
			$lastid=$this->db->insert_id();
			$cus_damage_id=$lastid;
			$disMsg='Sale successfully added';
			
			//insert sale item data
			$row=$this->input->post('row');
			$rowCount=$this->input->post('rowCount');
			$data_item=array();
			for($i=1; $i<=$rowCount; $i++){
				if(isset($row[$i]['product_id'][0]))
				 {
					
				 $data=array(
					 'cus_damage_id'=>$cus_damage_id,
					 'product_id'=>$row[$i]['product_id'][0],
				     'quantity'=>$row[$i]['qty'][0]
					//'pdmgitm_unit_cost'=>$row[$i]['unit_price'][0],
				
				);
				$this->Product_Damage_Customer_Model->save_product_damage_customer_item($data);
				
				
				}
			}
		
		}else {
			
			$disMsg='Please select these before adding any product:'.$disMsg;
		}	
		
		$this->session->set_flashdata('message', 'Product damage details successfully added!');
		
		echo json_encode(array('cus_damage_id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));
	}

	//Product  Damage reference no jenarate	
	public function get_next_ref_no(){
		$query=$this->Product_Damage_Customer_Model->get_next_ref_no();
		$result = $query->row();
		//print_r($result);
		$reference_no=sprintf("%05d", $result->cus_damage_id+1);
		$reference_no=$reference_no;
		echo json_encode(array('reference_no'=>$reference_no));
	}
	
	//Product  Damage ger avalable product qty
	

	//Product  Damage add form
    public function product_damage_add()
    {  
		  
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'product_damage_add';
		
		//get suppliers list
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['tax_rates_list'] = $this->Tax_Rates_Model->get_all_tax_rates();
		$data['customer_list'] = $this->Customer_Model->get_all_customers();
		$data['status_list'] = $this->Common_Model->get_all_status();
		$data['username_list'] = $this->Product_Damage_Customer_Model->get_all_username();
      //  $data['invoicenumber_list'] = $this->Product_Damage_Model->get_all_invoicenumber();
		    
			
          
             $this->load->view('product_damage_add_customer',$data);
    }
	
	//Product  Damage product items get
	 public function suggestions($value='')
    {
		$term=$this->input->get('term');
		$invoice_id=$this->input->get('invoice_id');
		$werehouse_id=$this->input->get('WH');
		$data['product_damage'] = $this->Product_Damage_Customer_Model->get_products_suggestions($invoice_id,$term);
		$json = array();
		//echo "Count:".count($data['product_damage']);
		//print_r($data['product_damage']);
		foreach ($data['product_damage'] as $row)
		{ 
		   	 
			$product_name=$row['product_name'];
			$product_code=$row['product_code'];
			$product_part_no=$row['product_part_no'];
			$product_oem_part_number=$row['product_oem_part_number'];
			$product_id=$row['product_id'];
			$product_price=$row['product_price'];
			$sendParameters="'$product_id','$product_name','$product_code','$product_price'";
			$sendParameters="$product_id,$product_name,$product_code,$product_price";
			$extraName='';
			$extraName.=", Selling Price: ".number_format($product_price, 2, '.', ',');
			if($product_part_no) $extraName.=", Part No: $product_part_no";
			if($product_oem_part_number) $extraName.=", OEM Part No: $product_oem_part_number";  
		    $qty=0;
			$item_qty=$this->Product_Damage_Customer_Model->get_avalable_product_qt($product_id,$invoice_id);
			$c_qty=$this->Product_Damage_Customer_Model->get_cus_damage_item_qty($product_id,$invoice_id);
			$damage_qty=$c_qty[0]['quantity'];
			$s_qty=$item_qty[0]['quantity'];
			$qty=($s_qty)-($damage_qty);
	 
			$extraName.=", Qty in stock: ".$qty;
			if($qty>0)
			{
			 $json_itm=array(
			 		'id'=> $row['product_id'],
					'product_id'=> $row['product_id'],
					'product_code'=> $row['product_code'],
					'product_name'=> $row['product_name'],
					'product_price'=> $row['product_price'],
					'product_part_no'=> $row['product_part_no'],
					'qtyforcheck'=> $qty,
					'product_oem_part_number'=> $row['product_oem_part_number'],
                    'value'=> $row['product_name']." (".$row['product_code'].")",
                    'label'=> $row['product_name']." (".$row['product_code'].")$extraName"
                    );
					array_push($json,$json_itm);
		}	
		}
		echo json_encode($json);		
    }
	
	//Sale details page

	
	
	
	public function get_all_invoice_by_warehouse_id()
	{
	
		$warehouse_id=$this->input->get('WH');
		$invoice = $this->Product_Damage_Customer_Model->get_all_invoice_by_warehouse_id($warehouse_id);
		echo json_encode($invoice);
		
		
	
		
	}
	public function check_avalable_product_qty(){
		$invoice_id=$this->input->get('invoice_id');
		$product_id=$this->input->get('product_id');
		$data['total']=$this->Product_Damage_Customer_Model->check_avalable_product_qty($invoice_id,$product_id); 
		echo json_encode(array('remmnaingQty'=>$data['total']));
		}
	public function get_customer_id()
	{
	    $cus_id='';
		$invoice_id=$this->input->get('ins_id');
		$cus_id = $this->Product_Damage_Customer_Model->get_sale_details($invoice_id);       
		echo json_encode( $cus_id);
		
		
	
		
	}
		
}