<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Reports extends CI_Controller
{
    var $main_menu_name = "reports";
    var $sub_menu_name = "suppliers";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Common_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Transfer_Model');
        $this->load->model('Sales_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Product_Damage_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Sequerty_Model');
        $this->load->model('Product_Models');
        $this->load->model('Customer_Model');
		$this->load->model('Purchase_Return_Model');
		$this->load->model('Marketing_Delivery_Model');
		$this->load->model('Bulk_Break_Model');
		$this->load->model('Customer_Order_Process_Model');
		$this->load->model('Pos_Model');
    }
    public function index()
    {
        $this->load->model('Supplier_Model');
        $data['suppliers']      = $this->Supplier_Model->get_all_supplier();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = $this->sub_menu_name;
        $this->load->view('rep_reports', $data);
    }
    public function payments()
    {
        $data['main_menu_name'] = 'reports';
        $data['sub_menu_name']  = 'reports/payments';
        $service_type           = $this->uri->segment('3');
        $data['service_type']   = $service_type;
        $pageName               = '';
        $data['pageName']       = $pageName;
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('rep_payments', $data);
    }
    public function cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque', $data);
    }
    public function cheque_hw()
    {
        $data['main_menu_name'] = 'hardware_reports';
        $data['sub_menu_name']  = 'cheque_hw';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque_hw', $data);
    }
    public function unrealized_cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'unrealized_cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_unrealized_cheque', $data);
    }
    public function return_cheque()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'return_cheque';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_cheque_return', $data);
    }
    public function payments_by_day()
    {
		$this->load->model('User_Model');
        $data['main_menu_name'] = 'reports';
        $data['sub_menu_name']  = 'reports/payments_by_day';
        $service_type           = $this->uri->segment('3');
        $data['service_type']   = $service_type;
        $pageName               = '';
        $data['pageName']       = $pageName;
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['user_list']      = $this->User_Model->getUsers();
        $this->load->view('rep_payments_by_day', $data);
    }
    public function get_list_payments_for_report()
    {
        $data             = array();
        $srh_to_date      = $this->input->post('srh_to_date');
        $srh_from_date    = $this->input->post('srh_from_date');
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        
        // if ($this->input->post('srh_to_date')) {
        //     $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        // }
        // if ($this->input->post('srh_from_date')) {
        //     $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        // }
        $values  = $this->Sales_Model->getPaymentsForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        if (!empty($values)) {
            foreach ($values as $users) {
                $row             = array();
                $bkng_id         = $users->sale_id;
                $paymnt_id       = $users->sale_pymnt_id;
                $row[]           = sprintf("%04d", $users->sale_pymnt_id);
                $row[]           = $users->sale_pymnt_date_time;
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                //$row[]  = "";//$users->user_first_name;
                $row[]  = $users->sale_payment_type;
                $row[]  = $users->sale_pymnt_paying_by;
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
	function get_cash_of_day(){
        $data             = array();
        $srh_date      = '';
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        $srh_type         = $this->input->get('srh_type');
        $srh_payment_term = $this->input->get('srh_payment_term');
		$srh_user_id	  = $this->input->get('srh_user_id');
        if ($this->input->get('srh_date')) {
            $srh_date = date('Y-m-d', strtotime($this->input->get('srh_date')));
        }
        $values  = $this->Sales_Model->get_cash_of_day($srh_warehouse_id, $srh_date, $srh_type, $srh_payment_term ,$srh_user_id);
		$output = array(
				'date'		=> $srh_date,
                'amount'	=> $values
            );
            echo json_encode($output);
    }
    public function print_product_code_popup()
    {
        $data['main_menu_name'] = 'reports';
        $cat_srh                = $this->uri->segment(3);
        $sub_cat_srh            = $this->uri->segment(4);
        $data['product_list']   = $this->Product_Models->getProductsProduCodePrint($cat_srh, $sub_cat_srh);
        $this->load->view('models/print_product_code_popup', $data);
    }
    public function print_product_barcode_list_popup()
    {
        $data['main_menu_name'] = 'reports';
        $cat_srh                = $this->uri->segment(3);
        $sub_cat_srh            = $this->uri->segment(4);
        $data['product_list']   = $this->Product_Models->getProductsProduCodePrint($cat_srh, $sub_cat_srh);
        $this->load->view('models/print_product_barcode_list_popup.php', $data);
    }
    public function print_product_code_list_popup()
    {
        $data['main_menu_name'] = 'reports';
        $cat_srh                = $this->uri->segment(3);
        $sub_cat_srh            = $this->uri->segment(4);
        $data['product_list']   = $this->Product_Models->getProductsProduCodePrint($cat_srh, $sub_cat_srh);
        $this->load->view('models/print_product_code_list_popup', $data);
    }
    public function print_product_code()
    {
        $this->load->model('category_models');
        $data['main_menu_name'] = 'reports';
        $data['sub_menu_name']  = 'print_product_code';
        $cat_srh                = $this->input->post('cat_srh');
        $sub_cat_srh            = $this->input->post('cat_srh');
        $data['category_list']  = $this->category_models->getCategory();
        $this->load->view('rep_product_code_print', $data);
    }
    public function get_list_product_for_code_print($value = '')
    {
        $cat_srh     = $this->input->post('cat_srh');
        $sub_cat_srh = $this->input->post('sub_cat_srh');
        $this->load->model('Product_Models');
        $values = $this->Product_Models->getProductsProduCodePrint($cat_srh, $sub_cat_srh);
        $data   = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $row    = array();
                $row    = array();
                $row[]  = $products->product_code;
                $row[]  = $products->product_name;
                $row[]  = $products->cat_name;
                $row[]  = $products->sub_cat_name;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function user_activitie()
    {
        $data['main_menu_name'] = 'reports';
        $data['sub_menu_name']  = 'user_activitie';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('rep_user_activitie', $data);
    }
    public function get_list_user_activitie_for_print($value = '')
    {
        $this->load->model('User_Model');
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d H:i:s', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d H:i:s', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'id',
            1 => 'id',
            2 => 'id',
            3 => 'id',
            4 => 'id'
        );
        $data          = array();
        $grn_data      = $this->User_Model->get_all_user_activitie_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date);
        $totalData     = count($grn_data);
        $totalFiltered = $totalData;
        foreach ($grn_data as $row) {
            $nestedData   = array();
            $id           = $row['id'];
            $nestedData[] = $row['details'];
            $nestedData[] = $row['user_first_name'];
            $nestedData[] = display_date_time_format($row['datetime']);
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function grn()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'grn';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['supplier_list']  = $this->Purchases_Model->get_supplier();
        $this->load->view('rep_grn', $data);
    }
    public function get_list_grn_for_print($value = '')
    {
        $this->load->model('Purchases_Model');
        $srh_to_date        = '';
        $srh_from_date      = '';
        $srh_warehouse_id   = $this->input->post('srh_warehouse_id');
        $srh_supplier_id    = $this->input->post('srh_supplier_id');
        $srh_payment_status = $this->input->post('srh_payment_status');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $grn_data      = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', $srh_supplier_id);
        $totalData     = count($grn_data);
        $totalFiltered = $totalData;
        foreach ($grn_data as $row) {
            $p_status          = '';
            $total_paid_amount = $row['grn_total_paid'];
            if (empty($total_paid_amount)) {
                $pay_st   = '<span class="label label-warning">Pending</span>';
                $p_status = 'Pending';
            } else {
                if ($total_paid_amount >= $row['grand_total']) {
                    $pay_st   = '<span class="label label-success">Paid</span>';
                    $p_status = 'Paid';
                } else {
                    $pay_st   = '<span class="label label-info">Partial</span>';
                    $p_status = 'Partial';
                }
            }
            if ($srh_payment_status) {
                if ($srh_payment_status == $p_status) {
                    $nestedData   = array();
                    $id           = $row['id'];
                    $nestedData[] = display_date_time_format($row['date']);
                    $nestedData[] = $row['reference_no'];
                    $nestedData[] = $row['supp_company_name'];
                    $nestedData[] = $pay_st;
                    $nestedData[] = number_format($row['grand_total'], 2, '.', '');
                    $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                    $nestedData[] = number_format($row['grand_total'] - $total_paid_amount, 2, '.', '');
                    $data[]       = $nestedData;
                }
            } else {
                $nestedData   = array();
                $id           = $row['id'];
                $nestedData[] = display_date_time_format($row['date']);
                $nestedData[] = $row['reference_no'];
                $nestedData[] = $row['supp_company_name'];
                $nestedData[] = $pay_st;
                $nestedData[] = number_format($row['grand_total'], 2, '.', '');
                $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                $nestedData[] = number_format($row['grand_total'] - $total_paid_amount, 2, '.', '');
                $data[]       = $nestedData;
            }
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function print_grn()
    {
        $this->load->model('Purchases_Model');
        $this->load->model('Supplier_Model');
        $srh_to_date                = '';
        $srh_from_date              = '';
        $srh_warehouse_id           = $this->input->get('srh_warehouse_id');
        $srh_supplier_id            = $this->input->get('srh_supplier_id');
        $srh_payment_status         = $this->input->get('srh_payment_status');
        $data['srh_payment_status'] = $srh_payment_status;
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d H:i:s', strtotime($this->input->get('srh_to_date')));
        }
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d H:i:s', strtotime($this->input->get('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $data['grn_list']  = $this->Purchases_Model->get_all_grn_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', $srh_supplier_id);
        $srh_supplier_name = '';
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['warehouse_details']  = $warehouse_details;
            $data['srh_warehouse_name'] = $warehouse_details['name'];
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        if ($srh_supplier_id) {
            $supplier_details  = $this->Supplier_Model->get_supplier_info($srh_supplier_id);
            $srh_supplier_name = $supplier_details['supp_company_name'];
        }
        $data['srh_supplier_name'] = $srh_supplier_name;
        if ($srh_to_date) {
            $data['srh_to_date_dis'] = display_date_time_format($srh_to_date);
        } else {
            $data['srh_to_date_dis'] = '';
        }
        if ($srh_from_date) {
            $data['srh_from_date_dis'] = display_date_time_format($srh_from_date);
        } else {
            $data['srh_from_date_dis'] = '';
        }
        $this->load->view('models/print_grn', $data);
    }
    public function daily_sales()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'daily_sales';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('rep_sales_daily', $data);
    }
    function daily_sales_hw()
    {
        $data['main_menu_name'] = 'hardware_reports';
        $data['sub_menu_name']  = 'daily_sales_hw';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('rep_sales_daily_hw', $data);
    }
    public function sales()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'sales';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_sales', $data);
    }
    public function print_sale()
    {
        $srh_to_date                = '';
        $srh_from_date              = '';
        $srh_warehouse_id           = $this->input->get('srh_warehouse_id');
        $srh_customer_id            = $this->input->get('srh_customer_id');
        $srh_payment_status         = $this->input->get('srh_payment_status');
        $data['srh_payment_status'] = $srh_payment_status;
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
        }
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $data['sales_list'] = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', '', $srh_customer_id);
        $srh_customer_name  = '';
        if ($srh_customer_id) {
            $customer_details          = $this->Customer_Model->get_customer_info($srh_customer_id);
            $data['srh_customer_name'] = $customer_details['cus_name'];
        } else {
            $data['srh_customer_name'] = "-All-";
        }
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['srh_warehouse_name'] = $warehouse_details['name'];
            $data['warehouse_details']  = $warehouse_details;
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        if ($srh_to_date) {
            $data['srh_to_date_dis'] = ($srh_to_date);
        } else {
            $data['srh_to_date_dis'] = '';
        }
        if ($srh_from_date) {
            $data['srh_from_date_dis'] = ($srh_from_date);
        } else {
            $data['srh_from_date_dis'] = '';
        }
        $this->load->view('models/print_sale', $data);
    }
    public function suppliers()
    {
        $this->load->model('Supplier_Model');
        $data['suppliers']      = $this->Supplier_Model->get_all_supplier();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = $this->sub_menu_name;
        $this->load->view('rep_suppliers', $data);
    }
    public function print_supplier()
    {
        $this->load->model('Supplier_Model');
        $data['suppliers_list'] = $this->Supplier_Model->get_all_supplier();
        $this->load->view('models/print_supplier', $data);
    }
    public function products()
    {
        $this->load->model('Product_Models');
        $this->load->model('category_models');
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['product_list']   = $this->Product_Models->getProducts('','','');
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'products';
        $data['category_list']  = $this->category_models->getCategory();
        $this->load->view('rep_products', $data);
    }
    public function hw_products()
    {
        $this->load->model('Product_Models');
        $this->load->model('category_models');
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['product_list']   = $this->Product_Models->getProducts('','','');
        $data['main_menu_name'] = 'hardware_reports';
        $data['sub_menu_name']  = 'products_hw';
        $data['category_list']  = $this->category_models->getCategory();
        $this->load->view('rep_products_hw', $data);
    }
    public function products_quantity()
    {
        $this->load->model('Product_Models');
        $this->load->model('category_models');
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        //$data['product_list']   = $this->Product_Models->getProducts();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'products_quantity';
        $data['category_list']  = $this->category_models->getCategory();
        $this->load->view('rep_products_quantity', $data);
    }
    public function supplier_products()
    {
        $this->load->model('Product_Models');
        $this->load->model('purchases_model');
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['product_list']   = $this->Product_Models->getProducts();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'supplier_products';
        $data['supplier_list']  = $this->purchases_model->get_supplier();
        $this->load->view('rep_supplier_products', $data);
    }
    public function alert_quantity()
    {
        $this->load->model('Product_Models');
        $this->load->model('category_models');
        $data['category_list']  = $this->category_models->getCategory();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        //$data['product_list']   = $this->Product_Models->getProducts();
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'alert_quantity';
        $this->load->view('rep_alert_quantity', $data);
    }
    public function print_products()
    {
        $this->load->model('Product_Models');
        $data['product_list'] = $this->Product_Models->getProducts();
        $this->load->view('models/print_products', $data);
    }
    public function print_alert_quantity()
    {
        $this->load->model('Product_Models');
        $data['product_list'] = $this->Product_Models->getProducts();
        $this->load->view('models/print_alert_quantity', $data);
    }
    function get_list_product_for_report($value = '')
    {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh          = $this->input->post('cat_srh');
        $srh_from_date    = '';
        $srh_to_date      = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Product_Models');
        $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh);
        $data   = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal              = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $row                 = array();

				$ss_warehouse_id = $this->session->userdata('ss_warehouse_id');				
				$transferd_qty       = $this->Transfer_Model->getTransferdQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $transfer_reseve_qty = $this->Transfer_Model->getTransferResevedQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $purchased_qty       = $this->Purchases_Model->getPurchasedQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $product_damaged_qty = $this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $sales_return_qty    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($ss_warehouse_id, $products->product_id);
                $sales_return_qty_hw    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId_hw($ss_warehouse_id, $products->product_id);
                $issue_qty           = $this->Customer_Order_Process_Model->get_all_cus_isued_item($ss_warehouse_id, $products->product_id);
                $return_qty          = $this->Customer_Order_Process_Model->get_all_cus_return_item($ss_warehouse_id, $products->product_id);
                $direct_sale_qty     = $this->Sales_Model->get_direct_sale_qty($ss_warehouse_id, $products->product_id);
                $hw_sale_qty         = $this->Pos_Model->get_hw_sale_qty($ss_warehouse_id,$products->product_id,"","");
                $mp       = $this->Bulk_Break_Model->getMpBreakQty($ss_warehouse_id, $products->product_id);
				$sp		  = $this->Bulk_Break_Model->getSpBreakQty($ss_warehouse_id, $products->product_id);
                
                $total_sold_qty = $issue_qty + $direct_sale_qty + $hw_sale_qty;
                $balance_qty                 = $purchased_qty - $total_sold_qty + $return_qty - $product_damaged_qty + $transfer_reseve_qty - $transferd_qty - $mp + $sp + $sales_return_qty_hw;    
                
                $sold_qty_in_units = $total_sold_qty *$products->pr_quantity;
                $balance_qty_in_units = $balance_qty*$products->pr_quantity;
				/**
				 * sub products
				 */
				$sps = $this->Product_Models->get_list_sp($products->product_id);
				if(!empty($sps)){
				    foreach($sps as $rw){
				        $hw_sp_sale_qty         = $this->Pos_Model->get_hw_sale_qty($ss_warehouse_id,$rw->product_id,"","");
                        $sold_qty_in_units +=   ($hw_sp_sale_qty * $rw->pr_quantity);
                        $balance_qty_in_units -=   ($hw_sp_sale_qty * $rw->pr_quantity);
            	    }
            	}
				/**
				 * ebd sub priducts 
				 */
			    
				
				$purchased_qty_with_units = number_format($purchased_qty * $products->pr_quantity, 2, '.', ',')." ".$products->unit_code;
				$sold_qty_with_units = number_format($sold_qty_in_units, 2, '.', ',')." ".$products->unit_code;
				$balance_qty_with_unit = number_format($balance_qty_in_units, 2, '.', ',')." ".$products->unit_code;
				
                $sale_price_sub_tot  = $products->product_price * $balance_qty;
                $cost_price_sub_tot  = $products->product_cost * $balance_qty;
                
                $row[]               = $products->product_code;
                $row[]               = $products->product_name;
                $row[]               = $products->cat_name;
                $row[]               = $products->sub_cat_name;
                $row[]               = "n/a";
                $row[]               = "n/a";
                $row[]               = $purchased_qty_with_units;
                $row[]               = $sold_qty_with_units;
                $row[]               = "n/a";
                $row[]               = "n/a";
				$row[]               = "n/a";
				$row[]               = "n/a";
                $row[]               = $balance_qty_with_unit;
				
                $data[]              = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_sales_for_print($value = '')
    {
        $srh_to_date        = '';
        $srh_from_date      = '';
        $srh_warehouse_id   = $this->input->post('srh_warehouse_id');
        $srh_customer_id    = $this->input->post('srh_customer_id');
        $srh_payment_status = $this->input->post('srh_payment_status');
        $srh_inv_type       = $this->input->post('in_type');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', '', $srh_customer_id, $srh_inv_type);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $p_status          = '';
            $pay_st            = '';
            $sale_id           = $row['sale_id'];
            $total_paid_amount = 0;
            $total_paid_amount = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
            $return_tot_amt    = 0;
            $return_tot_amt    = $this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
            $nestedData[]      = display_date_time_format($row['sale_datetime']);
            $nestedData[]      = $row['sale_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st   = '<span class="label label-warning">Pending</span>';
                $p_status = 'Pending';
            } else {
                if ($total_paid_amount >= ($row['sale_total'] - $return_tot_amt)) {
                    $pay_st   = '<span class="label label-success">Paid</span>';
                    $p_status = 'Paid';
                } else {
                    $pay_st   = '<span class="label label-info">Partial</span>';
                    $p_status = 'Partial';
                }
            }
            if ($srh_payment_status) {
                if ($srh_payment_status == $p_status) {
                    $nestedData[] = $pay_st;
                    $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                    $nestedData[] = $return_tot_amt;
                    $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                    $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                    $data[]       = $nestedData;
                }
            } else {
                $nestedData[] = $pay_st;
                $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                $nestedData[] = $return_tot_amt;
                $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                $data[]       = $nestedData;
            }
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_sales_report_for_print_daily($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_return_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $sale_id           = $row['sale_id'];
            $total_paid_amount = $row['total_paid_amount'];
            $nestedData[]      = display_date_time_format($row['sl_rtn_datetime']);
            $nestedData[]      = $row['sl_rtn_reference_no'];
			$nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sl_rtn_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = number_format($row['cost_total'], 2, '.', '');
            $nestedData[] = number_format($row['sl_rtn_total'], 2, '.', '');
            $nestedData[] = number_format($row['sl_rtn_total'] - $row['cost_total'], 2, '.', '');
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_sales_report_for_print_daily_hw($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_return_for_report_hw($srh_warehouse_id, $srh_to_date, $srh_from_date);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $sale_id           = $row['sale_id'];
            $total_paid_amount = $row['total_paid_amount'];
            $nestedData[]      = display_date_time_format($row['sl_rtn_datetime']);
            $nestedData[]      = $row['sl_rtn_reference_no'];
			$nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sl_rtn_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = number_format($row['cost_total'], 2, '.', '');
            $nestedData[] = number_format($row['sl_rtn_total'], 2, '.', '');
            $nestedData[] = number_format($row['sl_rtn_total'] - $row['cost_total'], 2, '.', '');
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_sales_for_print_daily($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_for_report($srh_warehouse_id, $srh_to_date, $srh_from_date);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $sale_id           = $row['sale_id'];
            $total_paid_amount = $row['total_paid_amount'];
            $nestedData[]      = display_date_time_format($row['sale_datetime']);
            $nestedData[]      = $row['sale_reference_no']."/".$row['card_ref_number'];
			$nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sale_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = number_format($row['cost_total'], 2, '.', '');
            $nestedData[] = number_format($row['sale_total'], 2, '.', '');
            $nestedData[] = number_format($row['sale_total'] - $row['cost_total'], 2, '.', '');
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    function get_list_sales_for_print_daily_hw($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_for_report_hw($srh_warehouse_id, $srh_to_date, $srh_from_date);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $sale_id           = $row['sale_id'];
            $total_paid_amount = $row['total_paid_amount'];
            $nestedData[]      = display_date_time_format($row['sale_datetime']);
            $nestedData[]      = $row['sale_reference_no']."/".$row['card_ref_number'];
			$nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sale_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = number_format($row['cost_total'], 2, '.', '');
            $nestedData[] = number_format($row['sale_total'], 2, '.', '');
            $nestedData[] = number_format($row['sale_total'] - $row['cost_total'], 2, '.', '');
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_supplier_for_print($value = '')
    {
        $this->load->model('Supplier_Model');
        $requestData   = $_REQUEST;
        $columns       = array(
            0 => 'supp_code',
            0 => 'supp_company_name',
            1 => 'supp_email',
            2 => 'supp_company_phone',
            3 => 'supp_city',
            4 => 'country_id',
            5 => 'supp_id'
        );
        $data          = array();
        $suppliers     = $this->Supplier_Model->get_all_supplier();
        $totalData     = count($suppliers);
        $totalFiltered = $totalData;
        foreach ($suppliers as $row) {
            $nestedData   = array();
            $nestedData[] = $row['supp_code'];
            $nestedData[] = $row['supp_company_name'];
            $nestedData[] = $row['supp_email'];
            $nestedData[] = $row['supp_company_phone'];
            $nestedData[] = $row['supp_city'];
            $nestedData[] = $row['country_short_name'];
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_supplier_product_for_print($value = '')
    {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $supplier_srh     = $this->input->post('supplier_srh');
        $this->load->model('Product_Models');
        $values = $this->Product_Models->getSupplierProductsForReport($srh_warehouse_id, $supplier_srh);
        $data   = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal              = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $row                 = array();
                $transferd_qty       = 0;
                $transfer_reseve_qty = 0;
                $transferd_qty       = $this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $transfer_reseve_qty = $this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $sold_qty            = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $purchased_qty       = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $product_damaged_qty = $this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $sales_return_qty    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $row                 = array();
                $balance_qty         = $purchased_qty + $transfer_reseve_qty + $sales_return_qty - $sold_qty - $transferd_qty - $product_damaged_qty;
                $row[]               = $products->product_code;
                $row[]               = $products->product_name;
                $row[]               = $products->supp_company_name;
                if ($products->product_part_no) {
                    $row[] = $products->product_part_no;
                } else {
                    $row[] = '';
                }
                $row[]  = number_format($purchased_qty, 2, '.', ',');
                $row[]  = number_format($sold_qty, 2, '.', ',');
                $row[]  = number_format($products->product_alert_qty, 2, '.', ',');
                $row[]  = number_format($balance_qty, 2, '.', ',');
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_product_for_print($value = '')
    {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh          = $this->input->post('cat_srh');
        $srh_from_date    = '';
        $srh_to_date      = '';
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Product_Models');
        $values = $this->Product_Models->getProductsForReport($srh_warehouse_id, $cat_srh);
        $data   = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal              = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $row                 = array();
                $transferd_qty=0;
				$transfer_reseve_qty=0;
				$transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				 
					
				$issue_qty=$this->Marketing_Delivery_Model->get_all_delivery_product_item($this->session->userdata('ss_warehouse_id'),$products->product_id);	
				$return_qty=$this->Marketing_Delivery_Model->get_all_return_product_item($this->session->userdata('ss_warehouse_id'),$products->product_id);
					
				$product_balance	=	$purchased_qty-$issue_qty+$return_qty-$product_damaged_qty+$transfer_reseve_qty-$transferd_qty;
				
                $sale_price_sub_tot  = $products->product_price * $product_balance;
                $cost_price_sub_tot  = $products->product_cost * $product_balance;
                $row[]               = $products->product_code;
                $row[]               = $products->product_name;
                $row[]               = $products->product_part_no;
                $row[]               = $products->cat_name;
                $row[]               = $products->sub_cat_name;
                $row[]               = $sale_price_sub_tot;
                $row[]               = $cost_price_sub_tot;
                $row[]               = number_format($purchased_qty, 2, '.', ',');
                $row[]               = number_format($sold_qty, 2, '.', ',');
                $row[]               = number_format($sales_return_qty, 2, '.', ',');
                $row[]               = number_format($product_damaged_qty, 2, '.', ',');
				$row[]               =	$issue_qty;
				$row[]               =	$return_qty;
                $row[]               = $product_balance;
				
                $data[]              = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
	function get_list_sales_return_for_sales_report($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        if ($this->input->post('srh_customer_id')) {
            $srh_customer_id = $this->input->post('srh_customer_id');
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_return_for_balance_report($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $total_paid_amount = $row['total_paid_amount'];
            $pay_st            = '';
            $nestedData[]      = display_date_time_format($row['sl_rtn_datetime']);
            $nestedData[]      = $row['sl_rtn_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sl_rtn_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = $row['sl_rtn_total'];
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_product_qty_for_print($value = '')
    {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh          = $this->input->post('cat_srh');
        $this->load->model('Product_Models');
        $values = $this->Product_Models->getProductsForQTYReport($srh_warehouse_id, $cat_srh);
        $data   = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal              = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $row                 = array();
                $transferd_qty       = 0;
                $transfer_reseve_qty = 0;
               /* $transferd_qty       = $this->Transfer_Model->getTransferdQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $transfer_reseve_qty = $this->Transfer_Model->getTransferResevedQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $sold_qty            = $this->Sales_Model->getSoldQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $purchased_qty       = $this->Purchases_Model->getPurchasedQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $product_damaged_qty = $this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($srh_warehouse_id, $products->product_id);
                $sales_return_qty    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($srh_warehouse_id, $products->product_id);*/
                
                $transferd_qty=$this->Transfer_Model->getTransferdQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$transfer_reseve_qty=$this->Transfer_Model->getTransferResevedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$sold_qty=$this->Sales_Model->getSoldQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$purchased_qty=$this->Purchases_Model->getPurchasedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				$product_damaged_qty=$this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				
				$sales_return_qty=$this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($this->session->userdata('ss_warehouse_id'),$products->product_id);
				 
					
				$issue_qty=$this->Marketing_Delivery_Model->get_all_delivery_product_item($this->session->userdata('ss_warehouse_id'),$products->product_id);	
				$return_qty=$this->Marketing_Delivery_Model->get_all_return_product_item($this->session->userdata('ss_warehouse_id'),$products->product_id);
					
				$product_balance	=	$purchased_qty-$issue_qty+$return_qty-$product_damaged_qty+$transfer_reseve_qty-$transferd_qty;
                $site_balance = $issue_qty-$return_qty-$sold_qty-$sales_return_qty;
                $site_varince="";
                
                $issue_balance=$issue_qty-$return_qty;
                $sales_balance=$sold_qty-$sales_return_qty;
                $site_varince="";
                if($issue_balance<$sales_balance)
                {
                    $site_varince               = number_format($issue_balance-$sales_balance, 2, '.', '');
                }
                
                
                $warehouse_variance="";
                if($issue_balance>$purchased_qty)
                {
                    $warehouse_variance  = number_format($purchased_qty-$issue_balance, 2, '.', '');
                }
                
                $row[]               = $products->product_code;
                $row[]               = $products->product_name;
                $row[]               = $products->cat_name;
                $row[]               = $products->sub_cat_name;
                $row[]               = number_format($purchased_qty, 2, '.', '');
                $row[]               = number_format($transferd_qty, 2, '.', '');
                $row[]               = number_format($transfer_reseve_qty, 2, '.', '');
                $row[]               = number_format($sold_qty, 2, '.', '');
                $row[]               = number_format($sales_return_qty, 2, '.', '');
                $row[]               = number_format($issue_qty, 2, '.', '');
                $row[]               = number_format($return_qty, 2, '.', '');
                $row[]               = number_format($product_balance, 2, '.', '');
                $row[]               = number_format($site_balance, 2, '.', '');
                $row[]               = number_format($product_balance+$site_balance, 2, '.', '');
                $row[]               =$warehouse_variance;
                 $row[]               =$site_varince;
                
                
                
              //  $row[]               = number_format(($products->product_price), 2, '.', '');
              //  $row[]               = number_format($tmp_qty, 2, '.', '');
               // $row[]               = number_format(($products->product_cost * $tmp_qty), 2, '.', '');
               // $row[]               = number_format(($products->product_price * $tmp_qty), 2, '.', '');
                $data[]              = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_product_alert_quantity_for_print($value = '')
    {
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $cat_srh          = $this->input->post('cat_srh');
        $this->load->model('Product_Models');
        $values = $this->Product_Models->getProductsForAlertQtyReport($srh_warehouse_id, $cat_srh);
        $data   = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                if ($products->product_status == 0) {
                    $k = "btn-warning";
                    $m = "fa-minus-circle";
                } else {
                    $k = "btn-green";
                    $m = "fa-check";
                }
                $retVal              = (empty($products->sub_cat_name)) ? "--:--" : $products->sub_cat_name;
                $transferd_qty       = $this->Transfer_Model->getTransferdQtyByWarehouseId($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $transfer_reseve_qty = $this->Transfer_Model->getTransferResevedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $purchased_qty       = $this->Purchases_Model->getPurchasedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $product_damaged_qty = $this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $sales_return_qty    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $issue_qty           = $this->Customer_Order_Process_Model->get_all_cus_isued_item($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $return_qty          = $this->Customer_Order_Process_Model->get_all_cus_return_item($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $direct_sale_qty     = $this->Sales_Model->get_direct_sale_qty($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $mp       = $this->Bulk_Break_Model->getMpBreakQty($this->session->userdata('ss_warehouse_id'), $products->product_id);
				$sp		  = $this->Bulk_Break_Model->getSpBreakQty($this->session->userdata('ss_warehouse_id'), $products->product_id);
                $balance_qty                 = $purchased_qty - $issue_qty + $return_qty - $product_damaged_qty + $transfer_reseve_qty - $transferd_qty-$direct_sale_qty - $mp + $sp;
                $row                 = array();
                //$balance_qty         = $purchased_qty + $transfer_reseve_qty + $sales_return_qty - $sold_qty - $transferd_qty - $product_damaged_qty;
                if ($balance_qty <= $products->product_alert_qty) {
                    $row[]  = $products->product_code;
                    $row[]  = $products->product_name;
                    //$row[]  = $products->product_part_no;
                    $row[]  = $products->cat_name;
                    $row[]  = $products->sub_cat_name;
                    $row[]  = $products->product_alert_qty;
                    $row[]  = $products->product_max_qty;
                    $row[]  = number_format(($balance_qty), 2, '.', ',');
                    
                    $req = $products->product_alert_qty-$balance_qty;
                    
                    if($req < 0)
                        $req = 0;
                    
                    $row[]  = number_format(($req), 2, '.', ',');
                    
                    $data[] = $row;
                }
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function customer_balance()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        if ($this->input->get('type')) {
            $data['wh']  = $this->input->get('wh');
            $data['cs']  = $this->input->get('cs');
            $data['dt']  = $this->input->get('dt');
            $data['csn'] = $this->input->get('csn');
            $this->load->view('rep_customer_balance_print', $data);
        } else {
            $this->load->view('rep_customer_balance', $data);
        }
    }
    public function get_list_sales_return_for_balance_report($value = '')
    {
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        if ($this->input->post('srh_customer_id')) {
            $srh_customer_id = $this->input->post('srh_customer_id');
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_return_for_balance_report($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $total_paid_amount = $row['total_paid_amount'];
            $pay_st            = '';
            $nestedData[]      = display_date_time_format($row['sl_rtn_datetime']);
            $nestedData[]      = $row['sl_rtn_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st = '<span class="label label-warning">Pending</span>';
            } else {
                if ($total_paid_amount >= $row['sl_rtn_total']) {
                    $pay_st = '<span class="label label-success">Paid</span>';
                } else {
                    $pay_st = '<span class="label label-info">Partial</span>';
                }
            }
            $nestedData[] = $pay_st;
            $nestedData[] = $row['sl_rtn_total'];
            $data[]       = $nestedData;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_list_payments_for_balance_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_customer_id  = $this->input->post('srh_customer_id');
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getPaymentsForBalance($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id, $srh_customer_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        if (!empty($values)) {
            foreach ($values as $users) {
                $row             = array();
                $bkng_id         = $users->sale_id;
                $paymnt_id       = $users->sale_pymnt_id;
                $row[]           = sprintf("%04d", $users->sale_pymnt_id);
                $row[]           = $users->sale_pymnt_date_time;
				
				if($srh_type == 'sale')
                $row[]           = $users->sale_reference_no;
				
				if($srh_type == 'sales_return')
                $row[]           = $users->sl_rtn_id;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_payment_type;
                $row[]  = $users->sale_pymnt_paying_by;
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_sales_for_print_balance($value = '')
    {
        $srh_to_date        = '';
        $srh_from_date      = '';
        $srh_warehouse_id   = $this->input->post('srh_warehouse_id');
        $srh_customer_id    = $this->input->post('srh_customer_id');
        $srh_payment_status = $this->input->post('srh_payment_status');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
        }
        $this->load->model('Sales_Model');
        $columns       = array(
            0 => 'sale_datetime',
            1 => 'sale_reference_no',
            2 => 'cus_name',
            3 => 'sale_id',
            4 => 'sale_id',
            5 => 'sale_id'
        );
        $data          = array();
        $sales         = $this->Sales_Model->get_all_sales_for_report_balance($srh_warehouse_id, $srh_to_date, $srh_from_date, '', '', '', $srh_customer_id);
        $totalData     = count($sales);
        $totalFiltered = $totalData;
        foreach ($sales as $row) {
            $nestedData        = array();
            $p_status          = '';
            $pay_st            = '';
            $sale_id           = $row['sale_id'];
            $total_paid_amount = 0;
            $total_paid_amount = $this->Sales_Model->get_total_paid_by_sale_id($sale_id);
            $return_tot_amt    = 0;
            $return_tot_amt    = $this->Sales_Return_Model->get_total_return_by_sale_id($sale_id);
            $nestedData[]      = $row['sale_id'];
            $nestedData[]      = display_date_time_format($row['sale_datetime']);
            $nestedData[]      = $row['sale_reference_no'];
            $nestedData[]      = $row['cus_name'];
            if (empty($total_paid_amount)) {
                $pay_st   = '<span class="label label-warning">Pending</span>';
                $p_status = 'Pending';
            } else {
                if ($total_paid_amount >= ($row['sale_total'] - $return_tot_amt)) {
                    $pay_st   = '<span class="label label-success">Paid</span>';
                    $p_status = 'Paid';
                } else {
                    $pay_st   = '<span class="label label-info">Partial</span>';
                    $p_status = 'Partial';
                }
            }
            if ($srh_payment_status) {
                if ($srh_payment_status == $p_status) {
                    $nestedData[] = $pay_st;
                    $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                    $nestedData[] = $return_tot_amt;
                    $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                    $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                    $nestedData[] = $row['sale_note'];
                    $data[]       = $nestedData;
                }
            } else {
                $nestedData[] = $pay_st;
                $nestedData[] = number_format($row['sale_total'], 2, '.', '');
                $nestedData[] = $return_tot_amt;
                $nestedData[] = number_format($total_paid_amount, 2, '.', '');
                $nestedData[] = number_format($row['sale_total'] - $return_tot_amt - $total_paid_amount, 2, '.', '');
                $nestedData[] = $row['sale_note'];
                $data[]       = $nestedData;
            }
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    public function get_unrealized_cheques()
    {
        $cash             = 0;
        $ret_amt          = 0;
        $srh_warehouse_id = $this->input->get('warehouse_id');
        $cus_id           = $this->input->get('cus_id');
        $date             = $this->input->get('date');
        $date             = date('Y-m-d', strtotime($date));
        $totcash          = 0;
        $cheque           = 0;
        $today            = date("Y-m-d");
        $total_paid       = $this->Sales_Model->getPaymentsForBalance($srh_warehouse_id, '', '', 'sale', '', '', $cus_id);
        if ($total_paid) {
            foreach ($total_paid as $row2) {
                if ($row2->sale_pymnt_paying_by != 'Return_Cash') {
                    if ($row2->sale_pymnt_paying_by == 'Cheque') {
                        if ($row2->sale_pymnt_date_time > $date) {
                            $cheque = $cheque + $row2->sale_pymnt_amount;
                        }
                    }
                }
            }
        }
        echo json_encode(array(
            'old_credit_amount' => $cheque
        ));
    }
    public function customer_balance_summery()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_summery_balance';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_customer_balance_summery', $data);
    }
    function print_customer_summery()
    {
        $data['main_menu_name'] = 'reports';
        $srh_warehouse_id       = $this->input->get('srh_warehouse_id');
        $srh_customer_id        = $this->input->get('srh_customer_id');
        $srh_from_date          = $this->input->get('srh_from_date');
        $srh_to_date            = $this->input->get('srh_to_date');
        $type                   = $this->input->get('type');
        $data['customers']      = $this->Customer_Model->get_customers($srh_customer_id);
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['srh_warehouse_name'] = $warehouse_details['name'];
            $data['warehouse_details']  = $warehouse_details;
            $data['warehouse_id']       = $srh_warehouse_id;
            $data['srh_from_date']      = $srh_from_date;
            $data['srh_to_date']        = $srh_to_date;
            $data['srh_customer_id']    = $srh_customer_id;
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        if ($type == 'a') {
            $data['summery'] = $this->Customer_Model->get_all_customer();
            $this->load->view('rep_summery_view', $data);
        }
        if ($type == 'b')
            $this->load->view('rep_summery_balance_view', $data);
    }
    public function get_list_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
       
		//print_r($values);
		$columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
				
				$bank='';
				if(!$users->bank_name){$bank=$users->sale_pymnt_note;}else{$bank=$users->bank_name;}
				
				
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = date('Y-m-d', strtotime($users->sale_pymnt_added_date_time));//site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $bank;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = date('Y-m-d', strtotime($users->sale_pymnt_date_time));//site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				
				
				$row[]  = $users->sale_pymnt_amount;
				
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_hw_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = 4;//$this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        
        $cheque_date       = $this->input->post('cheque_date');
        $cheque_no       = $this->input->post('cheque_no');
        
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        
        if ($this->input->post('cheque_date')) {
            $cheque_date = date('Y-m-d', strtotime($this->input->post('cheque_date')));
        }
      //$values  = $this->Sales_Model->getHwChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $values  = $this->Sales_Model->getHwChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $cheque_date, $cheque_no);
       
		//print_r($values);
		$columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
				
				$bank='';
				if(!$users->bank_name){$bank=$users->sale_pymnt_note;}else{$bank=$users->bank_name;}
				
				
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = date('Y-m-d', strtotime($users->sale_pymnt_added_date_time));//site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $bank;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = date('Y-m-d', strtotime($users->sale_pymnt_cheque_date));//site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				
				
				$row[]  = $users->sale_pymnt_amount;
				
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_unrealized_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getUnrealizedChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date( $users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
				$row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
				$row[]           = '';//$users->sale_pymnt_note_two;
                if($users->smp_amount>0)
                $row[]  = $users->smp_amount;
				else 
				$row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    public function get_list_return_cheque_for_report()
    {
        $data             = array();
        $srh_to_date      = '';
        $srh_from_date    = '';
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        $srh_type         = $this->input->post('srh_type');
        $srh_payment_term = $this->input->post('srh_payment_term');
        $ss_user_id       = $this->input->post('ss_user_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->post('srh_to_date')));
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->post('srh_from_date')));
        }
        $values  = $this->Sales_Model->getRetChequeForPrint($srh_warehouse_id, $srh_to_date, $srh_from_date, $srh_type, $srh_payment_term, $ss_user_id);
        $columns = array(
            0 => 'bkng_id',
            1 => 'bkng_id',
            2 => 'bkng_id',
            3 => 'bkng_id',
            4 => 'bkng_id',
            5 => 'bkng_id',
            6 => 'bkng_id',
            7 => 'bkng_id',
            8 => 'bkng_id'
        );
        $tmp_id  = 0;
        if (!empty($values)) {
            foreach ($values as $users) {
                $row       = array();
                $bkng_id   = $users->sale_id;
                $paymnt_id = $users->sale_pymnt_id;
                $tmp_id++;
                $row[]           = $tmp_id;
                $row[]           = $users->cus_name;
                $row[]           = site_date_time($users->sale_pymnt_added_date_time);
                $row[]           = $users->sale_pymnt_note;
                $row[]           = $users->sale_pymnt_cheque_no;
                $row[]           = site_date($users->sale_pymnt_date_time);
                $row[]           = $users->sale_reference_no;
                $pymnt_collected = '';
                $checked_status  = '';
                if ($pymnt_collected == 1) {
                    $checked_status = 'checked=\"checked\"';
                } else {
                    $checked_status = '';
                }
                $row[]  = $users->sale_pymnt_amount;
                $paid   = 0;
                $data[] = $row;
            }
            $output = array(
                'data' => $data
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
	function customer_receivable()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'customer_receivable';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers();
        $this->load->view('rep_customer_receivable', $data);
    }
    function customer_receivable_hw()
    {
        $data['main_menu_name'] = 'hardware_reports';
        $data['sub_menu_name']  = 'customer_receivable_hw';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['customer_list']  = $this->Customer_Model->get_all_customers_hw();
        $this->load->view('rep_customer_receivable_hw', $data);
    }
	function print_customer_receivable()
    {
        $data['main_menu_name'] = 'reports';
        $srh_warehouse_id       = $this->input->get('srh_warehouse_id');
        $srh_customer_id        = $this->input->get('srh_customer_id');
        $srh_from_date          = $this->input->get('srh_from_date');
        $srh_to_date            = $this->input->get('srh_to_date');
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['srh_warehouse_name'] = $warehouse_details['name'];
            $data['warehouse_details']  = $warehouse_details;
            $data['warehouse_id']       = $srh_warehouse_id;
            $customer_details           = $this->Customer_Model->get_all_customer_print($srh_customer_id);
            $data['customer_details']   = $customer_details;
            $data['srh_from_date']      = $srh_from_date;
            $data['srh_to_date']        = $srh_to_date;
            $data['srh_customer_id']    = $srh_customer_id;
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        $this->load->view('models/print_customer_receivable', $data);
    }
    function print_customer_receivable_hw()
    {
        
        $this->load->model('Pos_Model');
        $data['main_menu_name'] = 'reports';
        $srh_warehouse_id       = $this->input->get('srh_warehouse_id');
        $srh_customer_id        = $this->input->get('srh_customer_id');
        $srh_from_date          = $this->input->get('srh_from_date');
        $srh_to_date            = $this->input->get('srh_to_date');
        if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['srh_warehouse_name'] = $warehouse_details['name'];
            $data['warehouse_details']  = $warehouse_details;
            $data['warehouse_id']       = $srh_warehouse_id;
            $customer_details           = $this->Customer_Model->get_all_customer_print_hw_new($srh_customer_id,$srh_to_date,$srh_from_date);
            $data['customer_details']   = $customer_details;
            $data['srh_from_date']      = $srh_from_date;
            $data['srh_to_date']        = $srh_to_date;
            $data['srh_customer_id']    = $srh_customer_id;
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
        if(ENVIRONMENT == 'development')
            $this->load->view('models/print_customer_receivable_hw_new', $data);
        else $this->load->view('models/print_customer_receivable_hw', $data);
    }
    
    	public function finance_report()
	{
		$data['main_menu_name'] = $this->main_menu_name;
    	$data['sub_menu_name'] = 'finance_report';
    	$this->load->model('finance_model');
    	$this->load->model('Transactions_Model');
		$data['fixed_assets_master_list']=array();
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$data['srh_from_date'] = $this->input->post('srh_from_date');
		$data['srh_to_date'] =$this->input->post('srh_to_date');
		$data['srh_warehouse_id'] =$this->input->post('srh_warehouse_id');
		$data['mstr_expences_type_list'] = $this->finance_model->get_mstr_expences_type_list();
		$this->load->view('report_common/finance_report_trial_balance',$data);
	}
	
	
	
	public function transactions_expencess()
{
	$warehouse_id=$this->input->get('warehouse_id');
	$fxd_ass_id=$this->input->get('fxd_ass_id');
	$srh_from_date=$this->input->get('srh_from_date');
	$srh_to_date=$this->input->get('srh_to_date');
	$this->load->model('Report_Model');
 	$transactions_list = $this->Report_Model->get_transactions_list(5,$warehouse_id,$srh_from_date,$srh_to_date);
	$totalData=count($transactions_list);
	$totalFiltered = $totalData; 
	$data=array();
	$x=0;
	foreach($transactions_list as $row){
	$x++;
	$nestedData=array();
	$nestedData[]=$x;
	$nestedData[]=$row['fxd_ass_details'];
	$nestedData[]=$row['fxd_ass_name'];
	$nestedData[]=$row['etp_name'];
	$nestedData[]=site_date_time($row['acctrnss_date']);
	$nestedData[]=$row['acctrnss_amount'];
	$status='';
	if($row['fxd_ass_status']==1)
	{
	$status='<center><span class="label label-success">Enable</span></center>';
	}
	else if($row['fxd_ass_status']==0)
	{
	$status='<center><span class="label label-warning">Disable</span></center>';
	}
	$action='';
	$nestedData[]=$action;
	$data[]=$nestedData;
	}
	$json_data = array(
	"data"=>$data
	);
	 $json_data = array(
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);
        echo json_encode($json_data);
}	

	public function transactions_deposit()
{
	$warehouse_id=$this->input->get('warehouse_id');
	$fxd_ass_id=$this->input->get('fxd_ass_id');
	$srh_from_date=$this->input->get('srh_from_date');
	$srh_to_date=$this->input->get('srh_to_date');
	$this->load->model('Report_Model');
 	$transactions_list = $this->Report_Model->get_transactions_list(2,$warehouse_id,$srh_from_date,$srh_to_date);
	$totalData=count($transactions_list);
	$totalFiltered = $totalData; 
	$data=array();
	$x=0;
	foreach($transactions_list as $row){
	$x++;
	$nestedData=array();
	$nestedData[]=$x;
	$nestedData[]=$row['fxd_ass_details'];
	$nestedData[]=$row['fxd_ass_name'];
	$nestedData[]=$row['etp_name'];
	$nestedData[]=site_date_time($row['acctrnss_date']);
	$nestedData[]=$row['acctrnss_amount'];
	$status='';
	if($row['fxd_ass_status']==1)
	{
	$status='<center><span class="label label-success">Enable</span></center>';
	}
	else if($row['fxd_ass_status']==0)
	{
	$status='<center><span class="label label-warning">Disable</span></center>';
	}
	$action='';
	$nestedData[]=$action;
	$data[]=$nestedData;
	}
	$json_data = array(
	"data"=>$data
	);
	 $json_data = array(
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);
        echo json_encode($json_data);
}

public function cashier_summary_list()
    {
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['main_menu_name'] = 'hardware_reports';
        $data['sub_menu_name']  = 'cashier_summary_list';
        $this->load->view('report_common/cashier_summary_list', $data);
    }
    
     function get_cashier_summary_list()
	{	
	    $this->load->model('Report_Model');
	$requestData= $_REQUEST;	
	$start=$this->input->get('start');
	$length=$this->input->get('length');
	$search=$this->input->get('search');	
	$direct_sale=$this->input->get('direct_sale');	
	$data = array();	
	$totalData = 1000;//$this->pos_model->get_all_sales("","",$search,$direct_sale);
	$sales = $this->Report_Model->get_all_cashier_summery_list($start,$length,$search);
	$totalFiltered = $totalData; 	
	foreach ($sales as $row){
		$nestedData=array(); 
		$id=$row['c_float_mstr_id'];
		$nestedData[] =$row['c_f_m_date_time'];
		$nestedData[] =$row['ref_no'];
		$nestedData[] = $row['user_first_name']."  ".$row['user_last_name'];
		$nestedData[] = $row['name'];
		if($row['float_status']==1){
		   $pay_st='<span class="label label-warning">Active</span>'; 
		}else{
		    $pay_st='<span class="label label-success">Closed</span>';
		}
		$nestedData[]=$pay_st;	
		$nestedData[] = $row['float_details'];
		$nestedData[] = '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="'.base_url().'cash_balance/chashier_float_summay?id='.$id.'"><i class="fa fa-file-text-o"></i> Float Details</a></li>
                            </ul></div>'; 
		
	
		$data[] = $nestedData;
	}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
}