<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Area_Model extends CI_Model {
  
  private $tableName = 'master_area';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_areas() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("area_name", "desc");
		$this->db->where("area_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result();
  }

	function get_all_active_areas() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("area_name", "desc");
		$this->db->where("status",1);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
  }

	function save_area($area_data,$area_id)
	{
		if (!$area_id)
		{
			$this->db->insert($this->tableName,$area_data);
		}else {
			$this->db->where('area_id', $area_id);
			return $this->db->update($this->tableName,$area_data);
		}
	}	

		function get_all_area_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("area_id", "desc");
		$this->db->where("area_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}	
	
	// acccess area data
	function get_all_area() {
		$this->db->select('master_area.*,warehouses.name,user.user_first_name as user');
		$this->db->from('master_area');
		$this->db->join('user', 'user.user_id = master_area.added_by','left');
		$this->db->join('warehouses','master_area.warehouse_id = warehouses.id','left');
		$this->db->order_by('area_id', 'asc');
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	public function get_all_area_by_warehouse_id($warehouse_id)
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("warehouse_id", $warehouse_id);
		$query = $this->db->get();
		$data=array();
 		foreach ($query->result() as $row)
		{
			$data[$row->area_id] = $row->area_name;
		}
		return ($data);
	}

	public function get_area_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("area_id", $id);
		$this->db->order_by("area_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_area($area_id)
	{
		$this->db->where('area_id', $area_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_area($area_id)
	{
		$data = array(
			'status' => 0
		);	
		$this->db->where('area_id', $area_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_area($area_id)
	{
		$data = array(
			'status' => 1
		);	
		$this->db->where('area_id', $area_id);
		$this->db->update($this->tableName, $data);
	}
}