<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Broker_Model extends CI_Model {
  
  private $tableName = 'brokers';
  private $master_tableName = 'broker_discount';
  private $master_primary_key = 'pd_discount_id'; 
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_brokers() {
		$this->db->select($this->tableName.'.*');
		$this->db->where('broker_status', 1);
		$this->db->where('is_delete', 0);
		$query = $this->db->get($this->tableName);
		return $query->result();
  }	
  function get_all_active_inactive_brokers() {
		$this->db->select($this->tableName.'.*');
		//$this->db->where('broker_status', 1);
		$this->db->where('is_delete', 0);
		$query = $this->db->get($this->tableName);
		return $query->result();
  }
  function get_broker_details($id) {
		$this->db->select($this->tableName.'.*');
		$this->db->where('broker_id', $id);
		$query = $this->db->get($this->tableName);
		return $query->row_array();
  }
  	public function save_broker($data)
	{
		return $this->db->insert($this->tableName,$data);
	}
	public function update_broker($id,$data)
	{
		$this->db->where('broker_id', $id);
		return $this->db->update($this->tableName, $data);
	}
		public function get_item_discount_list($product_id)
	{
	  $this->db->select('bd.*');
	  $this->db->from('broker_discount bd');
	  $this->db->where('bd.product_id',$product_id);
	  $this->db->where('bd.status',1);				
	  $query=$this->db->get();
	  return $query->result();	
	}
	 function insert_update_master_table($data,$id)
	{
		if (!$id)
		{
			$result =$this->db->insert($this->master_tableName,$data);
			return $result;
		}
		else 
		{
		$this->db->where($this->master_primary_key,$id);
		return $this->db->update($this->master_tableName,$data);
		}
	}
	public function get_discount_detals_by_product_dis_id($discount_id)
	{
	  $this->db->select($this->master_tableName.'.*');
	  $this->db->from($this->master_tableName);
	  $this->db->where($this->master_tableName.'.pd_discount_id',$discount_id);		
	  $query=$this->db->get();
	  return $query->row_array();	
	}
	public function save_broker_payment($data)
	{
		return $this->db->insert('broker_payment',$data);
	}
	 function get_broker_payment_list($id='') {
		$this->db->select('bp.*');
		$this->db->select('mp.p_type_name');
		$this->db->select('u.user_first_name,u.user_last_name');
		$this->db->from('broker_payment bp');
		$this->db->join('mstr_payment_type mp','mp.p_type_id=bp.payment_type','left');
		$this->db->join('user u','u.user_id=bp.paid_by','left');
		$this->db->where('bp.broker_payment_status', 1);
		if($id){
		$this->db->where('bp.broker_id', $id);
		}
		$query = $this->db->get();
		return $query->result();
  }
   function get_pending_broker_discount_invoices($broker_id=''){
        $this->db->select('si.id,si.sale_id,si.product_id,si.quantity,si.gross_total');
         $this->db->select('bd.pd_discount_id,bd.discount_value,bd.is_precentage');
         $this->db->select('s.broker_id,s.price_type');
		$this->db->from('hw_sale_items si');
		$this->db->join('broker_discount bd','bd.product_id=si.product_id','inner');
		$this->db->join('hw_sales s','s.sale_id=si.sale_id','left');
		//$this->db->join('product p','p.product_id=si.product_id','left');
		$this->db->where('s.broker_procceed_status',0);
		$this->db->where("s.price_type != 'retail_wholesale'");
		if($broker_id){
		$this->db->where('s.broker_id', $broker_id);
		}
		$query = $this->db->get();
		return $query->result_array();
    }
    public function save_broker_commssion($data)
	{
		return $this->db->insert('broker_commission',$data);
	}
	public function update_sales_after_proceed($broker_id='',$data)
	{
	    $count=count($data);
	    if($count==1){
	        if($broker_id){
	        	$this->db->where('broker_id', $broker_id);
	       }
	    $this->db->where('broker_procceed_status',0);
	    return $this->db->update('hw_sales', $data);
	    }else{
	        return false;
	    }
	}
  function process_pending_broker_discount_invoices($broker_id=''){
      $result=	$this->get_pending_broker_discount_invoices($broker_id);
      foreach($result as $row){
          $commsiion_value=0;
          $commsiion_rate=0;
          if($row['is_precentage']==1){
              $commsiion_value=($row['gross_total']/100)*$row['discount_value'];
              $commsiion_rate=$row['discount_value']."%";
          }else{
               $commsiion_value=$row['quantity']*$row['discount_value'];
               $commsiion_rate=$row['discount_value'];
          }
          $is_approved_bill=1;
          if($row['price_type']=="retail_credit"){
              $is_approved_bill=0;
          }
          $data=array(
              'sale_id'=>$row['sale_id'],
              'sale_item_id'=>$row['id'],
              'product_id'=>$row['product_id'],
              'commission_value'=>$commsiion_value,
              'discount_id'=>$row['pd_discount_id'],
              'commition_rate'=>$commsiion_rate,
              'broker_id'=>$row['broker_id'],
              'broker_commission_status'=>$is_approved_bill,
              );
            $this->save_broker_commssion($data);
      }
       $data=array(
              'broker_procceed_status'=>1,
              );
        return $this->update_sales_after_proceed($broker_id,$data);
  }
  	 function get_broker_commssion_list($id='') {
		$this->db->select('bc.*');
		$this->db->select('s.sale_reference_no,s.sale_datetime');
		$this->db->select('p.product_name,p.product_code');
		$this->db->from('broker_commission bc');
		$this->db->join('hw_sales s','s.sale_id=bc.sale_id','left');
		$this->db->join('product p','p.product_id=bc.product_id','left');
		$this->db->where('bc.broker_commission_status', 1);
		if($id){
		$this->db->where('bc.broker_id', $id);
		}
		$query = $this->db->get();
		return $query->result();
  }
  function get_broken_commssion_total($id) {
		$this->db->select_sum('bc.commission_value');
		$this->db->from('broker_commission bc');
		$this->db->where('bc.broker_commission_status', 1);
		$this->db->where('bc.broker_id', $id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['commission_value'])){
		    return $result['commission_value'];
		}else{
		    return 0;
		}
  }
  function get_broker_pending_commssion_total($id) {
		$this->db->select_sum('bc.commission_value');
		$this->db->from('broker_commission bc');
		$this->db->where('bc.broker_commission_status', 0);
		$this->db->where('bc.broker_id', $id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['commission_value'])){
		    return $result['commission_value'];
		}else{
		    return 0;
		}
  }
  function get_broken_paid_total($id) {
		$this->db->select_sum('bc.broker_payment_amount');
		$this->db->from('broker_payment bc');
		$this->db->where('bc.broker_payment_status', 1);
		$this->db->where('bc.broker_id', $id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['broker_payment_amount'])){
		    return $result['broker_payment_amount'];
		}else{
		    return 0;
		}
  }
  function get_broken_deduction_total($id) {
		$this->db->select_sum('bc.broker_deduction_amount');
		$this->db->from('broker_commsiion_deduction bc');
		$this->db->where('bc.b_c_deduction_status', 1);
		$this->db->where('bc.broker_id', $id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['broker_deduction_amount'])){
		    return $result['broker_deduction_amount'];
		}else{
		    return 0;
		}
  }
  	 function get_broker_pending_commssion_list($id='') {
		$this->db->select('bc.*');
		$this->db->select('s.sale_reference_no,s.sale_datetime');
		$this->db->select('p.product_name,p.product_code');
		$this->db->from('broker_commission bc');
		$this->db->join('hw_sales s','s.sale_id=bc.sale_id','left');
		$this->db->join('product p','p.product_id=bc.product_id','left');
		$this->db->where('bc.broker_commission_status', 0);
		if($id){
		$this->db->where('bc.broker_id', $id);
		}
		$query = $this->db->get();
		return $query->result();
  }
  	public function update_broker_commsiion_table($data,$id='')
	{
	   if($id>0)
	   {
	       $this->db->where('broker_commission_id', $id);
	        return $this->db->update('broker_commission', $data);
	    }else{
	        return false;
	    }
	}
    function check_broker_discount_enable($product_id) {
		$this->db->from('broker_discount bd');
		$this->db->where('bd.status', 1);
		$this->db->where('bd.product_id', $product_id);
		$query = $this->db->get();
		return $query->num_rows();
    }
  	public function save_broker_deduction($data)
	{
		return $this->db->insert('broker_commsiion_deduction',$data);
	}
	 function get_broker_deduction_list($id='') {
		$this->db->select('bp.*');
		$this->db->select('mp.deduction_type');
		$this->db->select('u.user_first_name,u.user_last_name');
		$this->db->from('broker_commsiion_deduction bp');
		$this->db->join('mstr_commssion_deduction_type mp','mp.mcd_t_id=bp.deduction_type','left');
		$this->db->join('user u','u.user_id=bp.added_by','left');
		$this->db->where('bp.b_c_deduction_status', 1);
		if($id){
		$this->db->where('bp.broker_id', $id);
		}
		$query = $this->db->get();
		return $query->result();
  }
  
  function gey_mobile_number($id) {
		$this->db->select('broker_contact_no');
		$this->db->from($this->tableName);
		$this->db->where("broker_id",$id);//("id !=",$id);
		$query = $this->db->get();
		$value=$query->row_array();
		return $value['broker_contact_no'];
	}
	
	function gey_broker_name($id) {
		$this->db->select('broker_name');
		$this->db->from($this->tableName);
		$this->db->where("broker_id",$id);//("id !=",$id);
		$query = $this->db->get();
		$value=$query->row_array();
		return $value['broker_name'];
	}
  
   
      
 
	
	
	

	
}