<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customer_Model extends CI_Model {
  
  private $tableName = 'customer';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
 
 	function save_customer(&$customer_data,$cus_id=false)
	{
		if (!$cus_id)
		{
			$this->db->insert($this->tableName,$customer_data);
		}else {
			$this->db->where('cus_id', $cus_id);
			return $this->db->update($this->tableName,$customer_data);
		}
	}

	function get_all_customer_print($cus_id=false) {
		$this->db->select('customer.*, mstr_country.country_short_name');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->order_by("customer.cus_id", "desc");
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		if($cus_id){
		$this->db->where("customer.cus_id",$cus_id);
		}
		$query = $this->db->get();
		return $query->result();
	}
	
		
	function get_all_customers() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		//$this->db->where("cus_id", $id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function get_all_customers_hw() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);
		$this->db->where("route_id = 0");
		//$this->db->where("cus_warehouse_id",4);
		//("id !=",$id);
		//$this->db->where("cus_id", $id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	function get_all_customers_ds() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);
		//$this->db->where("cus_warehouse_id != 4");
		$this->db->where("route_id > 0");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function get_sms_customer_retail() {
		$this->db->select('cus_sms_number,cus_name');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);
		$this->db->where("cus_type","retail");
		$this->db->where("sms_status","enabled");
		$this->db->where("cus_sms_number != ''");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	function get_sms_customer_wholesale() {
		$this->db->select('cus_sms_number,cus_name');
		//$this->db->select($this->tableName.'.cus_sms_number');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);
		$this->db->where("cus_type","wholesale");
		$this->db->where("sms_status","enabled");
		$this->db->where("cus_sms_number != ''");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function get_all_customer_print_hw($cus_id=false) {
		$this->db->select('customer.*, mstr_country.country_short_name');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->order_by("customer.cus_name", "asc");
		//$this->db->where("customer.cus_warehouse_id",4);
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		if($cus_id){
		    $this->db->where("customer.cus_id",$cus_id);
		}
		$query = $this->db->get();
		return $query->result();
	}
	
	function get_all_customer_print_hw_new($cus_id=false,$srh_to_date="",$srh_from_date="") {
		$this->db->select('customer.cus_id,customer.cus_name,customer.cus_phone');
		$this->db->from('hw_sales');
		$this->db->join('customer', 'customer.cus_id = hw_sales.customer_id', 'left');
		$this->db->order_by("customer.cus_name", "asc");
		$this->db->where("hw_sales.customer_id !=",1);
		//$this->db->where("hw_sales.is_closed !=",1);
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		if($cus_id){
		    $this->db->where("customer.cus_id",$cus_id);
		}
		if ($srh_to_date) {
            $this->db->where("date(hw_sales.sale_datetime) <=", $srh_to_date); //
        }
        if ($srh_from_date) {
            $this->db->where("date(hw_sales.sale_datetime) >=", $srh_from_date); //
        }
		$this->db->group_by("hw_sales.customer_id");
		$query = $this->db->get();
		/*echo $this->db->last_query();
		exit;*/
		return $query->result();
	}
	
	function get_all_customers_by_area_id($route_id,$start="",$length="",$search="") {
		$this->db->select($this->tableName.'.*');
	//	$this->db->order_by("cus_id", "asc");
	//	$this->db->where("cus_status",1);
		
		$this->db->join('routes', 'customer.route_id = routes.route_id', 'left');
		
		$this->db->where("routes.area_id",$route_id);
		//("id !=",$id);
		//$this->db->where("cus_id", $id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function get_all_customer($start,$length,$search_key_val) {
		
		$search_key_val=preg_replace('/[^a-zA-Z0-9-_\.]/','', $search_key_val);
		
		$this->db->select($this->tableName.'.*');
		$this->db->select('routes.route_name');
		$this->db->from($this->tableName);
		$this->db->join('routes','routes.route_id=customer.route_id','left');
		
		if($search_key_val){
            $this->db->where("customer.cus_code LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'OR customer.cus_nic LIKE '%$search_key_val%'OR customer.cus_phone LIKE '%$search_key_val%'OR customer.city_name LIKE '%$search_key_val%'OR customer.cus_address LIKE '%$search_key_val%'");
       }
       $this->db->order_by("cus_name", "asc");
       if($start!='' && $length!='')
	   {
        $this->db->limit($length,$start);
       	$query = $this->db->get(); 
      	return $query->result_array();     		
	   }
		else
		{
			$query = $this->db->get(); 
			return  $query->num_rows();			
		}

	}
	
	public function get_customer_info($id)
	 {
		$this->db->select('*');
		$this->db->from('customer');
		$this->db->where("cus_id", $id);
		$this->db->order_by("cus_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_customer($cus_id)
	{
		$this->db->where('cus_id', $cus_id);
		$this->db->delete('customer');
	
	}

	public function disable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 0
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}
	
	public function enable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 1
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}	

	function get_all_customers_by_routes($routes) {
		$this->db->select($this->tableName.'.*');		
		$this->db->where("cus_status",1);//("id !=",$id);
		//$this->db->where("cus_type","normal");
		//$this->db->where_in("route_id",$routes);		
		$this->db->order_by("cus_name", "asc");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	
	function get_all_customers_by_routes_jason($routes) {
		$this->db->select($this->tableName.'.*');		
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_credit_status",1);
		$this->db->where_in("route_id",$routes);		
		$this->db->order_by("cus_name", "asc");
		$query = $this->db->get($this->tableName);
		$data=array(); 
		foreach ($query->result() as $row)
		{
			$data[$row->cus_id] = $row->cus_name." ( ".$row->cus_address." )";
		}
		return ($data);
	}
	
	function get_all_customers_by_route_id($route_id) {
		$this->db->select($this->tableName.'.*');		
		$this->db->where("cus_status",1);//("id !=",$id);
		if($route_id){
			$this->db->where("route_id",$route_id);	
		}
			
		$this->db->order_by("cus_name", "asc");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function get_credit_rejected_customers() {
		$this->db->select($this->tableName.'.*,ms.ap_status,u.user_first_name');
		$this->db->from($this->tableName);
		$this->db->join('master_approval_status ms','ms.app_value=cus_credit_status','left');
		$this->db->join('user u','u.user_id=credit_rejected_by','left');
		$this->db->order_by("cus_name", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_credit_status != 1");
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_credit_approved_customers() {
		$this->db->select($this->tableName.'.*,ms.ap_status,u.user_first_name');
		$this->db->from($this->tableName);
		$this->db->join('master_approval_status ms','ms.app_value=cus_credit_status','left');
		$this->db->join('user u','u.user_id=credit_approval_by','left');
		$this->db->order_by("cus_name", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		$this->db->where("cus_credit_status",1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_credit_status_by_customer_id($cus_id) {
		$this->db->select('cus_credit_status');
		$this->db->from($this->tableName);
		$this->db->where("cus_id",$cus_id);//("id !=",$id);
		$query = $this->db->get();
		$value=$query->row_array();
		
		return $value['cus_credit_status'];
	}
	
		function gey_mobile_number($cus_id) {
		$this->db->select('cus_sms_number');
		$this->db->from($this->tableName);
		$this->db->where("cus_id",$cus_id);//("id !=",$id);
		$query = $this->db->get();
		$value=$query->row_array();
		return $value['cus_sms_number'];
	}
	
	function gey_cus_name($cus_id) {
		$this->db->select('cus_name');
		$this->db->from($this->tableName);
		$this->db->where("cus_id",$cus_id);//("id !=",$id);
		$query = $this->db->get();
		$value=$query->row_array();
		return $value['cus_name'];
	}
	
}