<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Group_Discount_Model extends CI_Model {
  
  private $tableName = 'goup_of_discount';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_group_discounts() {
		$this->db->select($this->tableName.'.*');
		$this->db->where("gd_status", 1);
		$this->db->order_by("gd_group_code", "asc");
		$query = $this->db->get($this->tableName);
		return $query->result_array();
  }
	function save_group_discount($data,$id=false)
	{
		if (!$id)
		{
			$this->db->insert($this->tableName,$data);
		}else {
			$this->db->where('gd_id', $id);
			return $this->db->update($this->tableName,$data);
		}
	}
	function get_all_group_discount() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("gd_group_code", "desc");
		$query = $this->db->get($this->tableName);
		return $query->result_array(); 
	}
	public function get_group_discount_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("gd_id", $id);
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	public function delete_group_discount($id)
	{
		$this->db->where('gd_id', $id);
		$this->db->delete($this->tableName);
	}
	public function disable_group_discount($id)
	{
		$data = array(
			'gd_status' => 0
		);	
		$this->db->where('gd_id', $id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_group_discount($id)
	{
		$data = array(
			'gd_status' => 1
		);	
		$this->db->where('gd_id', $id);
		$this->db->update($this->tableName, $data);
	}
	
	public function get_customer_group_value($customer_id=''){
	    if($customer_id){
	        $result=$this->get_customer_group($customer_id);
	        if(isset($result['gd_grup_discount_val'])){
	            return $result['gd_grup_discount_val'];
	        }else{
	            return 0;
	        }
	    }else{
	        return 0;
	    }
	}
	private function get_customer_group($customer_id){
	    $this->db->select('g.gd_grup_discount_val');
		$this->db->from('customer c'); 
		$this->db->join('goup_of_discount g','g.gd_id=c.group_discount_id','inner');
		$this->db->where("c.cus_id", $customer_id);
		$query = $this->db->get();
		return $query->row_array();
	}
		public function check_product_cus_group_discount($prodcut_id){
	    if($prodcut_id){
	      $result=$this->get_product_group_discount_status($prodcut_id);
	      if(isset($result['group_discount'])){
	          return $result['group_discount'];
	      }else{
	          return 0;
	      }
	    }else{
	        return 0;
	    }
	    
	}
	private function get_product_group_discount_status($prodcut_id){
	    $this->db->select('p.group_discount');
		$this->db->from('product p'); 
		$this->db->where("p.product_id", $prodcut_id);
		$query = $this->db->get();
		return $query->row_array(); 
	}
	
	
}